#ifndef __CTrace__
#define __CTrace__

//	===========================================================================

#include "../Basics/CSystemString.hpp"
#include "../IO/CTextStream.hpp"
using Exponent::IO::CTextStream;
using Exponent::Basics::CSystemString;

//	===========================================================================

namespace Exponent
{
	namespace Testing
	{
		/**
		 * @class CTrace CTrace.hpp
		 * @brief Printing to the console, follows printf formatting conditions
		 *
		 * @date 21/08/2004
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 * @version 1.1.0 Added traceObject function
		 * @version 1.2.0 Added traceLog functionality
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CTrace.hpp,v 1.2 2007/02/08 21:06:44 paul Exp $
		 */
		class CTrace
		{
		public:

//	===========================================================================

			/**
			 * Output a debug string
			 * @param text The Text to output
			 * @param ... The arguments
			 */
			static void trace(const char *text, ...);

			/**
			 * Output an object
			 * @param theObject The object to trace
			 * @param formatText Formatting text placed before readout
			 */
			static void trace(const CCountedObject &theObject, const CString &formatText);

//	===========================================================================

			/**
			 * Open the log file
			 * @param filename The name of the file to open
			 * @retval bool  True if trace file opened properly, false otherwise
			 */
			static bool openTraceFile(const CSystemString &filename);

			/**
			 * Close the log file
			 */
			static void closeTraceFile();

//	===========================================================================

		protected:

//	===========================================================================

			static CTextStream CTRACE_STREAM;				/**< The text stream for file loggin */
		};
	}
}
#endif	// End of CTrace.hpp